<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Violation extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();

        // cek login
        if ($this->session->userdata('level') != 1 and $this->session->userdata('level') != 2) {
            $this->session->set_flashdata('info', 'Maaf, hanya admin dan pengajar yang berhak mengakses halaman ini');
            redirect('main/admin_login');
        }


        // Set template and directori content
        if ($this->session->userdata('level') == 1) {
            $this->template->set_template('backend/template/admin-template');
        } else {
            $this->template->set_template('backend/template/teacher-template');
        }
        $this->template->set_directory_content('backend/admin');
    }

    public function detail($code = null)
    {
        $classroom = $this->classroom_model->get_classroom_by_code($code);
        if ($classroom) {
            $data['classroom']     = $classroom;
            $data['violations'] = $this->classroom_model->get_violation(['classroom_id' => $classroom->ID]);
            $data['classroom_id'] = $classroom->ID;
            $this->template->view('violation', $data);
        } else {
            $this->session->set_flashdata('failed', 'Maaf, kode kelas tidak ditemukan!');
            redirect('admin/classroom');
        }
    }

    public function json_data($id)
    {
        echo $this->classroom_model->get_violation_datatables(['classroom_id' => $id]);
    }

    public function reset($id)
    {
        $this->classroom_model->update_violation(['id' => $id], ['status' => '0']);
        redirect($_SERVER['HTTP_REFERER']);
    }
}
